<?php

namespace ExportEngine\Service\Serialize;

class DataTransformer
{
    /**
     * @param array $data
     *
     * @return string
     */
    public static function pack(array $data): string
    {
        return base64_encode(serialize($data));
    }

    /**
     * @param string $str
     *
     * @return array
     */
    public static function unpack(string $str): array
    {
        return unserialize(base64_decode($str), ['allowed_classes' => false]);
    }
}
