<?php

namespace ExportEngine\Drivers;

use ExportEngine\Service\Serialize\ReadTransport;

class AbstractDriver
{
    protected $ext = '';

    protected $head = [];

    protected $readTransport;

    /**
     * @param string $tmpFile
     * @return $this
     */
    public function setSourceData($tmpFile): self
    {
        $this->readTransport = new ReadTransport($tmpFile);

        return $this;
    }

    /**
     * @param array $head
     * @return $this
     */
    public function setHead(array $head)
    {
        $this->head = $head;
        return $this;
    }

    /**
     * @return string
     */
    public function getExtension(): string
    {
        return $this->ext;
    }

    /**
     * @param string $value
     * @return string
     */
    public function prepareValue(string $value): string
    {
        return trim($value);
    }

    public function __destruct()
    {
        if (!empty($this->readTransport)) {
            $this->readTransport->close();
        }
    }
}
