<?php

namespace ExportEngine\Drivers;

use ExportEngine\Contracts\ExportDriverInterface;
use ExportEngine\Exceptions\ExportException;
use Spreadsheet_Excel_Writer;

/**
 * Xls export driver
 */
class Xls extends AbstractDriver implements ExportDriverInterface
{
    protected $ext = 'xls';

    /**
     * @param $sheet
     * @param $xls
     */
    protected function outputOnlyData($sheet, $xls): void
    {
        mb_internal_encoding('latin1');

        $row = $col = 0;
        $sheet->writeRow($row, $col, $this->head);

        $row = 1;
        foreach ($this->readTransport->read() as $data) {
            foreach ($data as $id => $value) {
                $data[$id] = $this->prepareValue($value);
            }
            $sheet->writeRow($row, 0, $data);
            $row++;
        }

        $xls->close();
    }

    /**
     * @param string $fileName
     */
    public function output(string $fileName): void
    {
        $xls = new Spreadsheet_Excel_Writer();
        $xls->setVersion(8);

        $xls->send($fileName);

        $sheet = $xls->addWorksheet();
        $sheet->setInputEncoding('UTF-8');

        $this->outputOnlyData($sheet, $xls);
    }

    /**
     * @param string $path
     * @throws ExportException
     */
    public function exportToFile(string $path): void
    {
        $xls = new Spreadsheet_Excel_Writer($path);
        $xls->setVersion(8);

        $sheet = $xls->addWorksheet();
        $sheet->setInputEncoding('UTF-8');

        $this->outputOnlyData($sheet, $xls);
    }
}
