<?php

namespace ExportEngine\Drivers;

use ExportEngine\Exceptions\ExportException;

/**
 *  Xml export driver
 */
class Xml2 extends Xml
{
    protected static $mapData = [
        'prd_name' => 'manufacturer',
        'comment' => 'name',
        'code' => 'oem_number'
    ];

    protected static $mapCache = [];

    /**
     * @return string
     */
    protected function getFirstLine(): string
    {
        $res = '<?xml version="1.0" encoding="UTF-8"?>' . PHP_EOL;
        $res .= '<offers>' . PHP_EOL;
        return $res;
    }

    /**
     * @return string
     */
    protected function getLastLine(): string
    {
        return '</offers>';
    }

    /**
     * обработка строки массива
     * @param array $row
     * @return string
     * @throws ExportException
     */
    protected function prepareRow(array $row): string
    {
        $head = $this->getStructureData($this->head);
        if (count($head) !== count($row)) {
            throw new ExportException('count head not not equal count row');
        }
        $res = '<offer>' . PHP_EOL;
        foreach ($row as $item) {
            $name = current($head);
            $res .= '<' . $name . '>' . $this->prepareValue($item) . '</' . $name . '>' . PHP_EOL;
            next($head);
        }

        return $res . '</offer>' . PHP_EOL;
    }


    /**
     * массив который будет использоваться л=для структуры строки
     * @param array $row
     * @return array
     */
    private function getStructureData(array $row): array
    {
        if (count(self::$mapCache)) {
            return self::$mapCache;
        }

        $map = $row;

        foreach (self::$mapData as $k => $v) {
            $key = array_search($k, $map);
            if ($key !== false) {
                $map[$key] = $v;
            }
        }

        self::$mapCache = $map;

        return self::$mapCache;
    }
}
