<?php

use Monolog\Logger;
use Monolog\Handler\StreamHandler;

require __DIR__ . '/../vendor/autoload.php';

$log = new Logger('name');
$log->pushHandler(new StreamHandler('php://stdout', Logger::DEBUG));
$ext = 'csv';

/**
 * @var \ExportEngine\Drivers\CsvLegacy $driver
 */
$driver = \ExportEngine\Factories\DriverFactory::buildByType($ext);
//$driver->setAsFormulas(true);
//$driver->setStrongEnclosure(true);

$exporter = new ExportEngine\Exporter($driver);


$exporter->setHeader([
    'id', 'name', 'email', 'code', 'address'
]);

$max = random_int(500, 600);
$t = 0;
$start = microtime(true);

for ($i = 0; $i < $max; $i++) {
    $exporter->addRow([
        'id' => $i,
        'name' => 'Вася Питериский',
        'email' => 'vacia@mail.ru',
        'password' => md5($i),
        'address' => 'Адрес: г. Киров обл., 610998, ул.Комсомольская, 34 '
    ]);

    $mem = round(memory_get_peak_usage(true) / 1024 / 1024, 2);

    if ($t > 100) {
        $log->debug('count data: ' . $i . ' mem, мб: ' . $mem);
        $t = 0;
    }
    $t++;
}

//ob_start();
//$exporter->output();
//ob_clean();

$exporter->exportToFile(__DIR__ . '/cache/file.' . $ext);

//$exporter->output("file.".$ext);

$finish = microtime(true);
$delta = $finish - $start;
echo $delta . ' сек., mem: ' .  round(memory_get_usage() / 1024 / 1024, 2);
