<?php

namespace ExportEngine\Factories;

use ExportEngine\Contracts\ExportProcessInterface;
use ExportEngine\Exceptions;
use ExportEngine\Drivers;

/**
 * Фабрика драйверов
 *
 * @author d.lanec
 */
class DriverFactory
{

    /**
     * Создание объекта по типу
     * @param $type
     * @return ExportProcessInterface
     * @throws Exceptions\FormatNotSupported
     */
    public static function buildByType(string $type): ExportProcessInterface
    {
        if (!method_exists(self::class, 'build' . $type)) {
            throw new Exceptions\FormatNotSupported($type);
        }

        return self::{'build' . $type}();
    }

    /**
     * csv драйвер
     *
     * @return \ExportEngine\Drivers\Csv
     */
    public static function buildCsv(): ExportProcessInterface
    {
        return new Drivers\Csv(new \SplTempFileObject());
    }

    /**
     * csv драйвер
     *
     * @return \ExportEngine\Drivers\Csv
     */
    public static function buildTxt(): ExportProcessInterface
    {
        return new Drivers\Txt(new \SplTempFileObject());
    }

    /**
     * xml драйвер
     * @return \ExportEngine\Drivers\Xml
     */
    public static function buildXML(): ExportProcessInterface
    {
        return new Drivers\Xml(new \SplTempFileObject());
    }

    /**
     * xml драйвер
     * @return \ExportEngine\Drivers\Xml
     */
    public static function buildXML2(): ExportProcessInterface
    {
        return new Drivers\Xml2(new \SplTempFileObject());
    }

    /**
     * Вар реализация Xlsx
     * @return ExportProcessInterface
     */
    public static function buildXlsx(): ExportProcessInterface
    {
        return new Drivers\Xlsx();
    }

    /**
     * реализация Xls
     * @return \ExportEngine\Drivers\Xlsx
     */
    public static function buildXls(): ExportProcessInterface
    {
        return new Drivers\Xls(new \SplTempFileObject());
    }

    /**
     * реализация Xls
     * @return \ExportEngine\Drivers\Xlsx
     */
    public static function buildHtml(): ExportProcessInterface
    {
        return new Drivers\Html(new \SplTempFileObject());
    }
}