# Функционал экспорта данных

## На текущий момент реализован экспорт в файлы форматов csv, html, txt,  xls, xlsx и xml, xml2.

### Инициализация
```php
$driver = \ExportEngine\Factories\DriverFactory::buildByType('csv');
$exporter = new ExportEngine\Exporter($driver); 
```

### Формирование данных
```php
$exporter->setHeader([
   'id','name', 'email'
]);

$max = random_int(1000, 2000);
for ($i = 0; $i < $max; $i++) {
    $data []= [
                'id'    =>  $i,
                'name' => 'Вася Питериский',
                'email' => 'vacia@mail.ru'
            ];
}
$exporter->setData($data);
```

### Формирование больших объемов
```php

$exporter->setHeader([
   'id','name', 'email'
]);

$max = random_int(1000000, 2000000);
for ($i = 0; $i < $max; $i++) {
    $exporter->addRow([
        'id'    =>  $i,
        'name' => 'Вася Питериский',
        'email' => 'vacia@mail.ru'
    ]);
}
```

## Вывод в буфер
```php
$exporter->output();
```

## Вывод в файл
```php
try{
    $exporter->exportToFile(__DIR__.'/cache/file.csv');
}
catch(Exception $ex){
    die($ex->getMessage());
}
```

## Посмотреть как работает в консоли
```bash
$ docker-compose up -d & docker-compose run codetools
$ php ./sandbox/example.php
```

## Протестировать unit
```bash
$ docker-compose up -d & docker-compose run codetools
$ phing test
```

## Производительность (i3-4150 @ 3.5GHz, Windows 10, php 7.2.30, opcache.enable)
Замеры | csv | txt | xml | xml2 | xls | xlsx
--- | --- | --- | --- |--- |--- |---
время на 10к записей,сек | 1.7 | 1.7 | 0.6 | 0.6 | 5,6 | 5,9
память на 10к записей,Мб | 6 | 6 | 6 | 6 | 54 | 56
--- | --- | --- | --- |--- |--- |---
время на 65к записей,сек | 9.5 | 8.8 | 2.0 | 2.0 | 37.5 | 50.6
память на 65к записей,Мб | 12 | 12 | 12 | 12 | 294 | 310 