<?php

namespace ExportEngine\Drivers;

use ExportEngine\Exceptions\ExportException;

/**
 *  экспорт в Xml
 *
 * @author d.lanec
 */
class Xml2 extends Xml
{

    private $ext = 'xml';

    /**
     * @return string
     */
    public function getExtendsion(): string
    {
        return $this->ext;
    }

    static protected $mapData = [
        'prd_name' => 'manufacturer',
        'comment' => 'name',
        'code' => 'oem_number'
    ];

    static protected $mapCache = [];


    /**
     * @return string
     */
    protected function getFirstLine(): string
    {
        $res = '<?xml version="1.0" encoding="UTF-8"?>' . PHP_EOL;
        $res .= '<offers>' . PHP_EOL;
        return $res;
    }

    /**
     * @return string
     */
    protected function getLastLine(): string
    {
        return '</offers>';
    }

    /**
     * обработка строки массива
     * @param array $row
     * @return string
     * @throws ExportException
     */
    protected function pepareRow(array $row): string
    {
        $head =  $this->getStrcutureData($this->head);
        if(count($head) !== count($row)){
            throw new ExportException('count head not not equal count row');
        }
        $res = '<offer>' . PHP_EOL;
        foreach ($row as $item) {
            $name = current($head);
            $res .= '<'.$name.'>' . $this->prepareValue($item). '</'.$name.'>' . PHP_EOL;
            next($head);
        }

        return $res . '</offer>' . PHP_EOL;
    }


    /**
     * массив который будет использоваться л=для структуры строки
     * @return array
     */
    private function getStrcutureData(array $row): array
    {
        if (count(self::$mapCache)) {
            return self::$mapCache;
        }

        $map = $row;

        foreach (self::$mapData as $k => $v) {
            $key = array_search($k, $map);
            if ($key !== false) {
                $map[$key] = $v;
            }
        }

        self::$mapCache = $map;

        return self::$mapCache;
    }

}