<?php

namespace ExportEngine\Drivers;

use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Writer\IWriter;

/**
 * driver for Xls
 *
 * @author d.lanec
 */
class Xls extends Xlsx
{

    protected $ext = 'xls';

    /**
     * @return IWriter
     * @throws \PhpOffice\PhpSpreadsheet\Writer\Exception
     */
    protected function createWriter(): IWriter
    {
        $this->fillSheetData(65535);
        $outputFileType = 'Xls';
        mb_internal_encoding('latin1');
        return IOFactory::createWriter($this->spreadsheet, $outputFileType);
    }
}