<?php

namespace ExportEngine\Drivers;

/**
 * Description of Html
 *
 * @author d.lanec
 */
class Html extends Csv
{
    /**
     *
     */
    public function output(): void
    {
        header('Content-type: text/html; charset=' . $this->charSet);
        $this->outputOnlyData();
    }

    /**
     * @return string
     */
    protected function getFirstLine(): string
    {
        $res = '<table class="table-csv-data">' . PHP_EOL;
        $res .= '<tbody>' . PHP_EOL;
        $res .= $this->pepareRow($this->head);
        return $res;
    }

    /**
     * @return string
     */
    protected function getLastLine(): string
    {
        return '</tbody>' . PHP_EOL . '</table>';
    }

    /**
     * обработка строки массива
     * @param array $row
     * @return string
     */
    protected function pepareRow(array $row): string
    {
        $res = '<tr>' . PHP_EOL;
        foreach ($row as $item) {
            $res .= '<td>' . $this->prepareValue($item) . '</td>' . PHP_EOL;
        }
        return $res . '</tr>' . PHP_EOL;
    }
}
