<?php

namespace ExportEngine\Contracts;

/**
 * Interface FileConfiguratorInterface
 *
 * @author Aleksei Kuznetsov
 */
interface FileConfiguratorInterface
{
    /**
     * Only file path (without his file name!).
     *
     * @param string $path
     */
    public function setPath(string $path): void;

    /**
     * Only file path (without his file name!).
     *
     * @return string
     */
    public function getPath(): string;

    /**
     * Only file name (without his extension!).
     *
     * @param string $name
     */
    public function setName(string $name): void;

    /**
     * Only file name (without his extension!).
     *
     * @return string
     */
    public function getName(): string;

    /**
     * The file name with his extension.
     *
     * @return string
     */
    public function getFileName(): string;

    /**
     * The full file path with his name and extension.
     *
     * @return string
     */
    public function getFilePath(): string;

    /**
     * @param string $extension
     */
    public function setExtension(string $extension): void;

    /**
     * @return string
     */
    public function getExtension(): string;
}
