<?php

namespace ExportEngine\Contracts;


use ExportEngine\Storage\SourceData;

/**
 * Interface ExportProcessInterface
 * @package ExportEngine\Contracts
 */
interface ExportProcessInterface
{
	public function setHead(array $head);
	
	public function setData(array $data) ;
	
	public function output(): void ;
	
	public function setFileName(string $name) ;
	
	public function getExtendsion(): string ;

	public function setCharSet(string $charSet) ;
	
	public function exportToFile(string $to): void ;

	public function setSourceData(SourceData $source);
}