# Функционал экспорта данных

## На текущий момент реализован экспорт в файлы форматов csv, html, txt,  xls, xlsx и xml, xml2.

### Инициализация
```php
$driver = \ExportEngine\Factories\DriverFactory::buildByType('csv');
$exporter = new ExportEngine\Exporter($driver); 
```

### Формирование данных
```php
$exporter->setHeader([
   'id','name', 'email'
]);

$max = random_int(1000, 2000);
for ($i = 0; $i < $max; $i++) {
    $data []= [
                'id'    =>  $i,
                'name' => 'Вася Питериский',
                'email' => 'vacia@mail.ru'
            ];
}
$exporter->setData($data);
```

### Формирование больших объемов
```php

$exporter->setHeader([
   'id','name', 'email'
]);

$max = random_int(1000000, 2000000);
for ($i = 0; $i < $max; $i++) {
    $exporter->addRow([
        'id'    =>  $i,
        'name' => 'Вася Питериский',
        'email' => 'vacia@mail.ru'
    ]);
}
```

## Вывод в буфер
```php
$exporter->output();
```

## Вывод в файл
```php
try{
    $exporter->exportToFile(__DIR__.'/cache/file.csv');
}
catch(Exception $ex){
    die($ex->getMessage());
}
```

## Посмотреть как работает в консоли
```bash
$ docker-compose up -d & docker-compose run codetools
$ php ./sandbox/example.php
```

## Протестировать unit
```bash
$ docker-compose up -d & docker-compose run codetools
$ phing test
```

## Производительность
Замеры | csv | txt | xml | xml2 | xls | xlsx
--- | --- | --- | --- |--- |--- |---
время на 10к записей,сек | 8,1 | 8,1 | 8,2 | 9,8 | 16,4 | 14,7
память на 10к записей,Мб | 1,2 | 1,2 | 1,2 | 1,2 | 26,4 | 28,7
--- | --- | --- | --- |--- |--- |---
время на 65к записей,сек | 41 | 41 | 41 | 41 | 112 | 96
память на 65к записей,Мб | 1,2 | 1,2 | 1,2 | 1,2 | 147 | 165 