<?php

namespace ExportEngine\Traits;

use PhpOffice\PhpSpreadsheet\Spreadsheet;

/**
 * Trait SpreadsheetAwareTrait
 *
 * @author Aleksei Kuznetsov
 */
trait SpreadsheetAwareTrait
{
    /**
     * @var Spreadsheet
     */
    protected $spreadsheet;

    /**
     * @param array $head
     */
    public function setHead(array $head): void
    {
        $this->spreadsheet->getActiveSheet()->fromArray($head);
    }

    /**
     * @param array $data
     */
    public function addData(array $data): void
    {
        $sheet = $this->spreadsheet->getActiveSheet();

        $sheet->fromArray(
            $data,
            null,
            'A' . ($sheet->getHighestRow() + 1)
        );
    }

    /**
     *
     */
    private function clearData(): void
    {
        $this->spreadsheet->disconnectWorksheets();
    }
}
