<?php

use Monolog\Logger;
use Monolog\Handler\StreamHandler;

require __DIR__ . '/../vendor/autoload.php';

$log = new Logger('name');
$log->pushHandler(new StreamHandler('php://stdout', Logger::DEBUG));
$ext = 'csv';

$driver = \ExportEngine\Factories\DriverFactory::buildByType($ext);


$exporter = new ExportEngine\Exporter($driver);

$exporter->setHeader([
    'id', 'name', 'email', 'code', 'address'
]);

$max = random_int(10000, 20000);
$t = 0;
$start = microtime(true);

for ($i = 0; $i < $max; $i++) {
    $data [] = [
        'id' => $i,
        'name' => 'Вася Питериский',
        'email' => 'vacia@mail.ru',
        'password' => md5($i),
        'address' => 'Адрес: г. Киров обл., 610998, ул.Комсомольская, 34 '
    ];

    $mem = round(memory_get_usage() / 1024 / 1024, 2);

    if ($t > 100) {
        $log->debug('count data: ' . $i . ' mem, мб: ' . $mem);
        $t = 0;
    }
    $t++;
}

$exporter->setData($data);

//ob_start();
//$exporter->output();
//ob_clean();

$exporter->exportToFile(__DIR__ . '/cache/file.' . $ext);

$finish = microtime(true);
$delta = $finish - $start;
echo $delta . ' сек.';
