<?php

namespace ExportEngine\Drivers;

use ExportEngine\Storage\SourceData;

/**
 *  экспорт в Xml
 *
 * @author d.lanec
 */
class Xml extends Csv
{

    private $ext = 'xml';

    /**
     * @return string
     */
    public function getExtendsion(): string
    {
        return $this->ext;
    }

    /**
     * вывод в xml
     */
    public function output(): void
    {
        $filename = filter_var($this->fileName, FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW);
        header("Content-Disposition: attachment; filename=\"$filename\"");
        header('Content-type: application/xml; charset=' . $this->charSet);
        $this->outputOnlyData();
    }


    /**
     * обработка строки массива
     * @param array $row
     * @return string
     */
    protected function pepareRow(array $row): string
    {
        $res = '<row>' . PHP_EOL;
        foreach ($row as $item) {
            $res .= '<cell>' . trim($item) . '</cell>' . PHP_EOL;
        }
        return $res . '</row>' . PHP_EOL;
    }

    /**
     * @return string
     */
    protected function getFirstLine(): string
    {
        $res = '<?xml version="1.0" encoding="UTF-8"?>' . PHP_EOL;
        $res .= '<rows>' . PHP_EOL;
        return $res;
    }

    /**
     * @return string
     */
    protected function getLastLine(): string
    {
        return '</rows>';
    }

}
