# Функционал экспорта данных

## На текущий момент реализован экспорт в файлы форматов csv, html, txt,  xls, xlsx и xml, xml2.

### Инициализация
```php
$driver = \ExportEngine\Factories\DriverFactory::buildByType('csv');
$exporter = new ExportEngine\Exporter($driver); 
```

### Формирование данных
```php
$exporter->setHeader([
   'id','name', 'email'
]);

$max = random_int(1000, 2000);
for ($i = 0; $i < $max; $i++) {
    $data []= [
                'id'    =>  $i,
                'name' => 'Вася Питериский',
                'email' => 'vacia@mail.ru'
            ];
}
$exporter->setData($data);
```

### Формирование больших объемов
```php

$exporter->setHeader([
   'id','name', 'email'
]);

$max = random_int(1000000, 2000000);
for ($i = 0; $i < $max; $i++) {
    $exporter->addRow([
        'id'    =>  $i,
        'name' => 'Вася Питериский',
        'email' => 'vacia@mail.ru'
    ]);
}
```

## Вывод в буфер
```php
$exporter->output();
```

## Вывод в файл
```php
try{
    $exporter->exportToFile(__DIR__.'/cache/file.csv');
}
catch(Exception $ex){
    die($ex->getMessage());
}
```