<?php

namespace ExportEngine\Drivers;

/**
 *  экспорт в Xml
 *
 * @author d.lanec
 */
class Xml extends Csv
{

    private $ext = 'xml';

    /**
     * @return string
     */
    public function getExtendsion(): string
    {
        return $this->ext;
    }

    /**
     * вывод в xml
     * @return string
     */
    public function output(): string
    {
        $filename = filter_var($this->fileName, FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW);
        header("Content-Disposition: attachment; filename=\"$filename\"");
        header('Content-type: application/xml; charset=' . $this->charSet);
        return $this->clearContent($this->createWriter()->toXML()->saveXML());
    }


    /**
     * @param string $content
     * @return string
     */
    private function clearContent(string $content): string
    {
        $content = preg_replace("~<\/csv>$~is", '', $content);
        $content = preg_replace("~<csv><row>~is", '<row>', $content);
        return $content;
    }

    /**
     * @return string
     */
    protected function getContentString(): string
    {
        $output = $this->createWriter()->toXML()->saveXML();

        if ($this->fp) {
            $output = preg_replace('~^<\?xml.*?csv>~is', '', $output);
        }

        $output = $this->clearContent($output);

        return $output;
    }

    /**
     * вставляем ранее вырезанный кусок
     * @throws \Exception
     */
    public function __destruct()
    {
        if ($this->fp && fwrite($this->fp, '</csv>') === false) {
            throw new \RuntimeException('write file error end line');
        }
        parent::__destruct();
    }
}
