<?php

namespace ExportEngine\Drivers;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use ExportEngine\Contracts\ExportProcessInterface;

/**
 * экспорт Xlsx
 *
 * @author d.lanec
 */
class Xlsx implements ExportProcessInterface
{

    protected $charSet;
    protected $data = [];
    protected $filename;
    protected $exportApi;
    protected $useXLSXWriter;
    protected $XLSXWriter;
    protected $head = [];
    private $ext = 'xlsx';
    private $sheet;
    private $spreadsheet;

    /**
     * Xlsx constructor.
     * @throws \PhpOffice\PhpSpreadsheet\Exception
     */
    public function __construct()
    {

        // $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
        $this->spreadsheet = new Spreadsheet();

        $this->sheet = $this->spreadsheet->getActiveSheet();
    }

    /**
     * @return string
     */
    public function getExtendsion(): string
    {
        return $this->ext;
    }

    /**
     * @return array
     */
    public function getHead(): array
    {
        return $this->head;
    }

    /**
     * @param array $head
     * @return $this
     */
    public function setHead(array $head)
    {
        $this->head = $head;
        return $this;
    }

    /**
     * @return string
     * @throws \PhpOffice\PhpSpreadsheet\Writer\Exception
     */
    public function output(): string
    {

        $writer = $this->createWriter();
        ob_start();
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment; filename="' . $this->filename . '"');
        $writer->save('php://output');
        return ob_get_clean();
    }

    private function createWriter(): \PhpOffice\PhpSpreadsheet\Writer\Xlsx
    {

        $chars = range('A', 'Z');

        foreach ($this->head as $value) {
            $this
                ->sheet
                ->setCellValue(current($chars) . 1, $value);
            next($chars);
        }

        reset($chars);
        $i = 2;
        foreach ($this->data as $row) {
            foreach ($row as $k => $value) {
                $this
                    ->sheet
                    ->setCellValue(current($chars) . $i, $value);
                next($chars);
            }
            $i++;
            reset($chars);
        }

        return new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($this->spreadsheet);
    }

    /**
     * @param string $file
     * @param int $flag
     * @throws \PhpOffice\PhpSpreadsheet\Writer\Exception
     */
    public function exportToFile(string $file, int $flag = 0): void
    {
        $this->createWriter()->save($file);
    }


    /**
     * @param string $charSet
     * @return $this
     */
    public function setCharSet(string $charSet)
    {
        $this->charSet = $charSet;
        return $this;
    }

    /**
     * @param array $data
     * @return $this
     */
    public function setData(array $data)
    {
        $this->data = $data;
        return $this;
    }

    /**
     * @param string $name
     * @return $this
     */
    public function setFileName(string $name)
    {
        $this->filename = $name;
        return $this;
    }
}
