<?php
/**
 * Created by PhpStorm.
 * User: d.lanec
 * Date: 12.05.2020
 * Time: 14:38
 */

namespace ExportEngine\Drivers;


use League\Csv\Writer;

/**
 * Модифифированный лиговский класс для записи данных
 * Class WriterLeague
 * @package ExportEngine\Drivers
 */
class WriterLeague extends Writer
{
    /**
     * @param string $root_name
     * @param string $row_name
     * @param string $cell_name_def
     * @param array $map
     * @return \DOMDocument
     */
    public function toXML2($root_name = 'csv', $row_name = 'row', $cell_name_def = 'cell', array $map)
    {

        $doc = new \DOMDocument('1.0', 'UTF-8');
        $root = $doc->createElement($root_name);

        foreach ($this->convertToUtf8($this->getQueryIterator()) as $row) {
            $rowElement = $doc->createElement($row_name);

            reset($map);

            array_walk($row, function ($value) use (&$rowElement, $doc, &$map, $cell_name_def) {
                if(!$cell_name = current($map)){
                    $cell_name = $cell_name_def;
                }
                $content = $doc->createTextNode($value);
                $cell = $doc->createElement($cell_name);
                $cell->appendChild($content);
                $rowElement->appendChild($cell);
                next($map);
            });
            $root->appendChild($rowElement);
        }
        $doc->appendChild($root);

        return $doc;
    }
}