<?php

namespace ExportEngine\Drivers;

/**
 * Description of Html
 *
 * @author d.lanec
 */
class Html extends Csv
{
    /**
     * @return string
     */
    public function output(): string
    {
        header('Content-type: text/html; charset=' . $this->charSet);
        return $this->createWriter()->toHTML();
    }


    /**
     * @return string
     */
    protected function getContentString(): string
    {
        $output = $this->createWriter()->toHTML();
        if ($this->fp) {
            $output = preg_replace('~^<table.*?>~is', '', $output);
        }

        $output = preg_replace("~<\/table>$~is", '', $output);

        return $output;
    }

    /**
     * вставляем ранее вырезанный кусок
     * @throws \Exception
     */
    public function __destruct()
    {
        if ($this->fp && fwrite($this->fp, '</table>') === false) {
            throw new \RuntimeException('write file error end line');
        }
        parent::__destruct();
    }
}
