<?php

namespace ExportEngine\Drivers;

use League\Csv\Writer;

/**
 *  экспорт в Xml
 *
 * @author d.lanec
 */
class Xml2 extends Xml
{

    private $ext = 'xml';

    /**
     * @return string
     */
    public function getExtendsion(): string
    {
        return $this->ext;
    }

    static protected $mapData = [
        'prd_name' => 'manufacturer',
        'comment' => 'name',
        'code' => 'oem_number'
    ];

    static protected $mapCache = [];

    /**
     * вывод в xml
     * @return string
     */
    public function output(): string
    {
        $filename = filter_var($this->fileName, FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW);
        header("Content-Disposition: attachment; filename=\"$filename\"");
        header('Content-type: application/xml; charset=' . $this->charSet);
        return $this
            ->createWriter2()
            ->toXML2('offers', 'offer', 'cell', $this->getStrcutureData())
            ->saveXML();
    }

    /**
     * массив который будет использоваться л=для структуры строки
     * @return array
     */
    protected function getStrcutureData(): array
    {
        if (count(self::$mapCache)) {
            return self::$mapCache;
        }

        $map = array_keys($this->data[0]);

        foreach (self::$mapData as $k => $v) {
            $key = array_search($k, $map);
            if ($key !== false) {
                $map[$key] = $v;
            }
        }

        self::$mapCache = $map;

        return self::$mapCache;
    }

    /**
     * @return string
     */
    protected function getContentString(): string
    {

        $output = $this
            ->createWriter2()
            ->toXML2('offers', 'offer', 'cell', $this->getStrcutureData())
            ->saveXML()
        ;

        if ($this->fp) {
            $output = preg_replace('~^<\?xml.*?offers>~is', '', $output);
        }

        $output = preg_replace("~<\/offers>$~is", '', $output);

        return $output;
    }


    /**
     * @return WriterLeague
     */
    protected function createWriter2(): WriterLeague
    {
        $writer = WriterLeague::createFromStream(tmpfile());

        $writer->setDelimiter($this->separator);

        $writer->setEscape($this->escape);
        $writer->setNewline($this->linebreak);


        //небольшой костыль для принудительного экранирование значений
        $writer->setEnclosure($this->enclosure);

        if ($this->charSet === 'utf-8') {
            $writer->setOutputBOM(Writer::BOM_UTF8); //adding the BOM sequence on output
        }

        if (!empty($this->head)) {
            $writer->insertOne($this->head);
        }

        $writer->insertAll($this->data);

        return $writer;
    }

    /**
     * вставляем ранее вырезанный кусок
     * @throws \Exception
     */
    public function __destruct()
    {
        if ($this->fp && fwrite($this->fp, '</offers>') === false) {
            throw new \RuntimeException('write file error end line');
        }
        Csv::__destruct();
    }
}