<?

namespace ExportEngine\Drivers;

/**
 * driver for Xls
 *
 * @author d.lanec
 */
class Xls extends Csv
{

    private $ext = 'xls';

    /**
     * @return string
     */
    public function getExtendsion(): string
    {
        return $this->ext;
    }

    /**
     * @return string
     */
    public function output():string
    {
        $filename = filter_var($this->fileName, FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW);
        header('Content-Transfer-Encoding: binary');
        header('Pragma: no-cache');
        header('Expires: 0');
        header("Content-Disposition: attachment; filename=\"$filename\"");
        header('Content-type: application/vnd.ms-excel; charset=' . $this->charSet);
        return $this->createWriter()->__toString();
    }

}