# Функционал экспорта данных

На текущий момент реализован экспорт в файлы форматов csv, html, txt, 
xls, xlsx и xml.

## Вывод в буфер

```php
$driver = \ExportEngine\Factories\DriverFactory::buildByType('csv');

$exporter = new ExportEngine\Exporter($driver);

$exporter->setHeader([
    'name', 'email'
]);

$max = random_int(10, 20);
for ($i = 0; $i < $max; $i++) {
    $exporter->addRow([
        'name' => 'Вася Питериский',
        'email' => 'vacia@mail.ru'
    ]);
}


echo $exporter->output();
```

## Вывод в файл
```php
try{
    $exporter->exportToFile(__DIR__.'/cache/file.csv');
}
catch(Exception $ex){
    
}
```