<?

namespace ExportEngine\Drivers;

/**
 * driver for Xls
 *
 * @author d.lanec
 */
class Xls extends Csv
{

	public function getExtendsion()
	{
		return "xls";
	}

	public function output()
	{
		$filename = filter_var($this->fileName, FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW);
		header('Content-Transfer-Encoding: binary');
		header('Pragma: no-cache');
		header('Expires: 0');
		header("Content-Disposition: attachment; filename=\"$filename\"");
		header("Content-type: application/vnd.ms-excel; charset=" . $this->charSet);
		return $this->createWriter()->__toString();
	}

}