# Функционал экспорта данных в форматы csv,xls,txt,xml и тд

## Вывод в браузер
```
		try{
			$driver = \ExportEngine\DriverFactory::buildByType("csv");
		} catch (\ExportEngine\Exceptions\FormatNotSupported $ex) {
			return Response::error('validation error',$ex->getMessage());
		}
		
		
		$exportEngine = new \ExportEngine\Exporter($driver);
		
		echo $exportEngine
				->setFileName("price-log")
				->setheader( ["id", "datetime", "line", "producer", "article", "amount", "price", "term", "comment"])
				->setdata([
					[
						1,"2017-07-22",1,"MAHLE","kl9",23,1200.50,2,"test position"
					]
				])
				->output();
```

## Сохранение в файле
```
		try{
			$driver = \ExportEngine\DriverFactory::buildByType("csv");
		} catch (\ExportEngine\Exceptions\FormatNotSupported $ex) {
			return Response::error('validation error',$ex->getMessage());
		}
		
		
		$exportEngine = new \ExportEngine\Exporter($driver);
		
		$exportEngine
				->setheader( ["id", "datetime", "line", "producer", "article", "amount", "price", "term", "comment"])
				->setdata([
					[
						1,"2017-07-22",1,"MAHLE","kl9",23,1200.50,2,"test position"
					]
				])
				->exportToFile("/home/www/prices/price.csv");
```

## Сохранение в файле и работа с большими данными
```
		try{
			$driver = \ExportEngine\DriverFactory::buildByType("csv");
		} catch (\ExportEngine\Exceptions\FormatNotSupported $ex) {
			return Response::error('validation error',$ex->getMessage());
		}
		
		$file = "/home/www/prices/price.csv";
		
		$exportEngine = new \ExportEngine\Exporter($driver);
		
		//создаем пустой файл
		$exportEngine
				->setheader( ["id", "datetime", "line", "producer", "article", "amount", "price", "term", "comment"])
				->exportToFile($file);

		$manyData = $this->getManyData();

		foreach($manyData as $row){

			//наполняем данными
			$exportEngine
					->setheader([])
					->addRow($row)
					;
					
			//сбрасываем в файл, можно сбрасывать пачками		
			$exportEngine->exportToFile($file);		
		}

		

```