<?

namespace ExportEngine\Drivers;

/**
 * экспорт Xlsx
 *
 * @author d.lanec
 */
class Xlsx implements \ExportEngine\Contracts\ExportProcessInterface
{

	protected $charSet;
	protected $data = [];
	protected $filename;
	protected $exportApi;
	protected $head = [];

	public function __construct()
	{
		$this->exportApi = \Loader::getApi("export");
	}

	public function getExtendsion()
	{
		return "xlsx";
	}

	/**
	 * 
	 * @param array $head
	 * @return $this
	 */
	public function setHead(array $head)
	{
		$this->head = $head;
		return $this;
	}

	/**
	 * 
	 * @return type
	 */
	public function output()
	{
		$newHead = [];

		foreach ($this->head as $k => $h) {
			$newHead [$k] = [
				"caption"	 => $h,
				"format"	 => $this->exportApi->getPhpExcelCellFormat(null)
			];
		}

		$data = [
			"name"	 => $this->filename,
			"head"	 => $newHead,
			"body"	 => $this->data
		];

		return $this->exportApi->createXLSXFile($data);
	}
	
	/**
	 * 
	 * @param type $file
	 * @return type
	 */
	public function exportToFile($file, $flag = 0)
	{
		$newHead = [];

		foreach ($this->head as $k => $h) {
			$newHead [$k] = [
				"caption"	 => $h,
				"format"	 => $this->exportApi->getPhpExcelCellFormat(null)
			];
		}

		$data = [
			"name"	 => $this->filename,
			"head"	 => $newHead,
			"body"	 => $this->data
		];		
		
		//$data['fullPath'] = $file;
		
		$fileData =  $this->exportApi->makeXLSXFile($data);
		
		return copy($_SERVER['DOCUMENT_ROOT'] . $fileData['relativePath'],$file);
	}

	

	/**
	 * set achar set
	 * @param type $charSet
	 * @return $this
	 */
	public function setCharSet($charSet)
	{
		$this->charSet = $charSet;
		return $this;
	}

	/**
	 * set data
	 * @param array $data
	 * @return $this
	 */
	public function setData(array $data)
	{
		$this->data = $data;
		return $this;
	}

	/**
	 * set filename
	 * @param type $name
	 * @return $this
	 */
	public function setFileName($name)
	{
		$this->filename = $name;
		return $this;
	}

}