<?

namespace ExportEngine\Drivers;

/**
 *  экспорт в Xml 
 *
 * @author d.lanec
 */
class Xml extends Csv
{
	
	public function getExtendsion()
	{
		return "xml";
	}
	
	/**
	 * вывод в xml
	 * @return type
	 */
	public function output()
	{
		$filename = filter_var($this->fileName, FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW);
		header("Content-Disposition: attachment; filename=\"$filename\"");
		header("Content-type: application/xml; charset=" . $this->charSet);
		return $this->createWriter()->toXML()->saveXML();	
	}
	
	/**
	 * save file to path
	 * @param type $path
	 */
	public function exportToFile($path, $flag = 0)
	{
		return file_put_contents($path, $this->createWriter()->toXML()->saveXML(),$flag);
	}	

}