<?

namespace ExportEngine;

use SplFileObject;

/**
 * Движек экспорта данных в различные форматы
 * 
 * 1. Позволяет экспортировать в csv,xml,xlsx,xls
 * 2. Данные вставляет как целым массивом так и построчно
 * 3. Вывод в файл на сервере так и на скачку в браузер 
 * 
 * @author d.lanec
 */
class Exporter
{

	protected $driver;
	protected $data = [];
	protected $header = [];
	protected $fileName;
	protected $charSet = "utf-8";

	public function __construct(Contracts\ExportProcessInterface $driver)
	{
		$this->driver = $driver;
		$this->fileName = sprintf("tempfile.%s", $this->driver->getExtendsion());
	}

	/**
	 * 
	 * @param type $charSet
	 * @return $this
	 */
	function setCharSet($charSet)
	{
		$this->charSet = $charSet;
		return $this;
	}

	/**
	 * 
	 * @param type $filename
	 * @return $this
	 */
	public function setFileName($filename)
	{
		$this->fileName = $filename;
		return $this;
	}

	/**
	 * 
	 * @param array $data
	 * @return $this
	 */
	public function addData(array $data)
	{
		$this->data = array_merge($data, $this->data);
		return $this;
	}

	/**
	 * 
	 * @param array $header
	 * @return $this
	 */
	public function setheader(array $header)
	{
		$this->header = $header;
		return $this;
	}

	/**
	 * 
	 * @param array $data
	 * @return $this
	 */
	public function setData(array $data)
	{
		$this->data = $data;
		return $this;
	}

	/**
	 * 
	 * @return type
	 */
	public function output()
	{
		return $this
						->driver
						->setCharSet($this->charSet)
						->setFileName(sprintf("%s.%s",$this->fileName,$this->driver->getExtendsion() ))
						->setHead($this->header)
						->setData($this->data)
						->output()
		;
	}


}