<?

namespace ExportEngine\Drivers;

/**
 * экспорт Xlsx
 *
 * @author d.lanec
 */
class Xlsx implements \ExportEngine\Contracts\ExportProcessInterface
{

	protected $charSet;
	protected $data = [];
	protected $filename;
	protected $exportApi;
	protected $head = [];

	public function __construct()
	{
		$this->exportApi = \Loader::getApi("export");
	}

	public function getExtendsion()
	{
		return "xlsx";
	}

	/**
	 * 
	 * @param array $head
	 * @return $this
	 */
	public function setHead(array $head)
	{
		$this->head = $head;
		return $this;
	}

	/**
	 * 
	 * @return type
	 */
	public function output()
	{
		$newHead = [];

		foreach ($this->head as $k => $h) {
			$newHead [$k] = [
				"caption"	 => $h,
				"format"	 => $this->exportApi->getPhpExcelCellFormat($obTemplate)
			];
		}

		$data = [
			"name"	 => $this->filename,
			"head"	 => $newHead,
			"body"	 => $this->data
		];

		return $this->exportApi->createXLSXFile($data);
	}

	/**
	 * set achar set
	 * @param type $charSet
	 * @return $this
	 */
	public function setCharSet($charSet)
	{
		$this->charSet = $charSet;
		return $this;
	}

	/**
	 * set data
	 * @param array $data
	 * @return $this
	 */
	public function setData(array $data)
	{
		$this->data = $data;
		return $this;
	}

	/**
	 * set filename
	 * @param type $name
	 * @return $this
	 */
	public function setFileName($name)
	{
		$this->filename = $name;
		return $this;
	}

}