<?

namespace ExportEngine\Drivers;

use League\Csv\Writer;

/**
 * Description of Csv
 *
 * @author d.lanec
 */
class Csv implements \ExportEngine\Contracts\ExportProcessInterface
{
	
	protected $file;
	protected $data;
	protected $separator = ";";
	protected $linebreak = "\r\n";
	protected $fileName;
	protected $charSet;
	protected $head;

	static $ext = "csv";
	
	function __construct(\SplFileObject $file)
	{
		$this->file = $file;
	}
	
	/**
	 * 
	 * @param array $head
	 * @return $this
	 */
	public function setHead(array $head)
	{
		$this->head = $head;
		return $this;
	}
	
	/**
	 * 
	 * @param type $charSet
	 * @return $this
	 */
	public function setCharSet($charSet)
	{
		$this->charSet = $charSet;
		return $this;
	}
	
	/**
	 * 
	 * @return string
	 */
	public function getExtendsion()
	{
		return self::$ext;
	}
	
	/**
	 * 
	 * @param type $name
	 * @return $this
	 */
	public function setFileName($name){
		$this->fileName = $name;
		return $this;
	}

	/**
	 * 
	 * @param type $separator
	 * @return $this
	 */
	public function setSeparator($separator)
	{
		$this->separator = $separator;
		return $this;
	}

	/**
	 * 
	 * @param type $linebreak
	 * @return $this
	 */
	public function setLinebreak($linebreak)
	{
		$this->linebreak = $linebreak;
		return $this;
	}	
	
	/**
	 * 
	 * @return string
	 */
	public function output()
	{
		$filename = filter_var($this->fileName, FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW);
		header('Content-Transfer-Encoding: binary');
		header("Content-Disposition: attachment; filename=\"$filename\"");
		header("Content-Type: text/csv; charset=" . $this->charSet);
		return $this->createWriter()->__toString();		
	}

	/**
	 * 
	 * @param array $data
	 * @return $this
	 */
	public function setData(array $data)
	{
		$this->data = $data;
		return $this;
	}
	
	/**
	 * 
	 * @return \League\Csv\Writer
	 */
	protected function createWriter(){
		
		$writer = Writer::createFromFileObject($this->file); 

		$writer->setDelimiter($this->separator);
		$writer->setNewline($this->linebreak); 
		
		$writer->setOutputBOM(Writer::BOM_UTF8); //adding the BOM sequence on output
		
		$writer->insertOne($this->head);
		$writer->insertAll($this->data);

		return $writer;	
	}

	
}