<?

namespace ExportEngine\Drivers;

/**
 * Description of Html
 *
 * @author d.lanec
 */
class Html extends Csv
{
	/**
	 * вывод в html
	 * @return type
	 */
	public function output()
	{
		header("Content-type: text/html; charset=" . $this->charSet);
		return $this->createWriter()->toHTML();	
	}


    /**
     * @return string
     */
    protected function getContentString()
    {
        $output = $this->createWriter()->toHTML();
        if($this->fp){
            $output = preg_replace("~^<table.*?>~is","",$output);
        }

        $output = preg_replace("~<\/table>$~is","",$output);

        return $output;
    }

    /**
     * вставляем ранее вырезанный кусок
     * @throws \Exception
     */
    public function __destruct()
    {
        if(fwrite($this->fp, "</table>") === false ){
            throw new \Exception("write file error end line");
        }
        parent::__destruct();
    }
}