<?php

namespace ExportEngine\Concrete\Configurators;

use ExportEngine\Contracts\FileLinesConfiguratorInterface;

/**
 * Class FileLinesConfigurator
 *
 * @author Aleksei Kuznetsov
 */
class FileLinesConfigurator extends FileConfigurator implements FileLinesConfiguratorInterface
{
    /**
     * @var string
     */
    private $charset = 'UTF-8';
    /**
     * @var string
     */
    private $delimiter = ';';
    /**
     * @var string
     */
    private $enclosure = '"';
    /**
     * @var string
     */
    private $lineEnding = PHP_EOL;

    /**
     * @param string $charset
     */
    public function setCharset(string $charset): void
    {
        $this->charset = strtoupper($charset);
    }

    /**
     * @return string
     */
    public function getCharset(): string
    {
        return $this->charset;
    }

    /**
     * @param string $delimiter
     */
    public function setDelimiter(string $delimiter): void
    {
        $this->delimiter = $delimiter;
    }

    /**
     * @return string
     */
    public function getDelimiter(): string
    {
        return $this->delimiter;
    }

    /**
     * @param string $enclosure
     */
    public function setEnclosure(string $enclosure): void
    {
        $this->enclosure = $enclosure;
    }

    /**
     * @return string
     */
    public function getEnclosure(): string
    {
        return $this->enclosure;
    }

    /**
     * @param string $lineEnding
     */
    public function setLineEnding(string $lineEnding): void
    {
        $this->lineEnding = $lineEnding;
    }

    /**
     * @return string
     */
    public function getLineEnding(): string
    {
        return $this->lineEnding;
    }
}
