# Функционал экспорта данных

На текущий момент реализован экспорт в файлы форматов csv, html, txt, 
xls, xlsx и xml.

## Сохранение в файле

```php
$fileConfigurator = new \ExportEngine\Concrete\Configurators\FileConfigurator();
$fileConfigurator->setPath($_SERVER['DOCUMENT_ROOT'] . '/price-logs');
$fileConfigurator->setName('price-log');

try {
    $driver = \ExportEngine\Factories\DriverFactory::buildByFileType('xls', $fileConfigurator);
} catch (\ExportEngine\Exceptions\FileFormatNotSupportedException $e) {
    exit($e->getMessage());
}

$driver->setHead(['id', 'datetime', 'line', 'producer', 'article']);
$driver->addData([
    [1, '2017-07-22', 1, 'MAHLE', 'kl9'],
    [2, '2017-07-21', 2, 'MAHLE', 'f87'],
    [3, '2017-07-24', 3, 'MAHLE', 'b98s'],
]);

$exporter = new \ExportEngine\Exporter($driver);

try {
    $exporter->export();
} catch (\ExportEngine\Exceptions\ExportException $e) {
    exit($e->getMessage());
}
```

## Вывод в браузер

Вывод файла на экран практически аналогичен простому созданию файла.
Разница лишь в классе-экспортере.

```php
$exporter = new \ExportEngine\OnScreenExporter($driver);

try {
    $exporter->export();
} catch (\ExportEngine\Exceptions\ExportException $e) {
    exit($e->getMessage());
}
```


## Работа с большими данными

Чтобы работать с большими данными, необходимо установить кэш, в который 
временно будут сохраняться все данные. Кэш должен реализовывать PSR-16 
интерфейс.

```php
$memCache = \Warframe\Cache\CacheFactory::createMemCached();

if (!$memCache->connect()) {
    exit('MemCache error connect');
}

\ExportEngine\Helpers\CacheAwareEngine::setCache($memCache);
```