<?php

namespace ExportEngine\Helpers;

use PhpOffice\PhpSpreadsheet\Settings as PhpSpreadsheetSettings;
use Psr\SimpleCache\CacheInterface;

/**
 * Class CacheAwareEngine
 *
 * @author Aleksei Kuznetsov
 */
class CacheAwareEngine
{
    /**
     * Sets the implementation of cache that should be used for cell collection.
     *
     * @param CacheInterface $cache
     */
    public static function setCache(CacheInterface $cache): void
    {
        PhpSpreadsheetSettings::setCache($cache);
    }
}
