<?

namespace ExportEngine\Drivers;

use League\Csv\Writer;

/**
 *  экспорт в Xml
 *
 * @author d.lanec
 */
class Xml2 extends Xml
{

    public function getExtendsion()
    {
        return "xml";
    }

    static protected $mapData = [
        "prd_name" => "manufacturer",
        "comment" => "name",
        "code" => "oem_number"
    ];

    static protected $mapCache = [];

    /**
     * массив который будет использоваться л=для структуры строки
     * @return array
     */
    protected function getStrcutureData(): array
    {
        if (count(self::$mapCache)) {
            return self::$mapCache;
        }

        $map = array_keys($this->data[0]);

        foreach (self::$mapData as $k => $v) {
            $key = array_search($k, $map);
            if ($key !== false) {
                $map[$key] = $v;
            }
        }

        self::$mapCache = $map;

        return self::$mapCache;
    }

    /**
     * @return string
     */
    protected function getContentString()
    {

        $output = $this->createWriter()->toXML2("offers", "offer", "cell", $this->getStrcutureData())->saveXML();

        if ($this->fp) {
            $output = preg_replace("~^<\?xml.*?offers>~is", "", $output);
        }

        $output = preg_replace("~<\/offers>$~is", "", $output);

        return $output;
    }

    /**
     * вставляем ранее вырезанный кусок
     * @throws \Exception
     */
    public function __destruct()
    {
        if($this->fp && fwrite($this->fp, "</offers>") === false ){
            throw new \Exception("write file error end line");
        }
        Csv::__destruct();
    }

    /**
     *
     * @return \League\Csv\Writer
     */
    protected function createWriter()
    {

        $writer = WriterLeague::createFromStream(tmpfile());

        $writer->setDelimiter($this->separator);
        $writer->setEnclosure($this->enclosure);
        $writer->setEscape($this->escape);
        $writer->setNewline($this->linebreak);

        if ($this->charSet == 'utf-8') {
            $writer->setOutputBOM(Writer::BOM_UTF8); //adding the BOM sequence on output
        }

        if (!empty($this->head)) {
            $writer->insertOne($this->head);
        }

        $writer->insertAll($this->data);

        return $writer;
    }

}