<?

namespace ExportEngine\Drivers;

/**
 *  экспорт в Xml 
 *
 * @author d.lanec
 */
class Xml extends Csv
{
	
	public function getExtendsion()
	{
		return "xml";
	}
	
	/**
	 * вывод в xml
	 * @return type
	 */
	public function output()
	{
		$filename = filter_var($this->fileName, FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW);
		header("Content-Disposition: attachment; filename=\"$filename\"");
		header("Content-type: application/xml; charset=" . $this->charSet);
		return $this->createWriter()->toXML()->saveXML();	
	}



    /**
     * @return string
     */
    protected function getContentString()
    {
        $output =  $this->createWriter()->toXML()->saveXML();

        if($this->fp){
            $output = preg_replace("~^<\?xml.*?csv>~is","",$output);
        }

        $output = preg_replace("~<\/csv>$~is","",$output);

        return $output;
    }

    /**
     * вставляем ранее вырезанный кусок
     * @throws \Exception
     */
    public function __destruct()
    {
        if($this->fp && fwrite($this->fp, "</csv>") === false ){
            throw new \Exception("write file error end line");
        }
        parent::__destruct();
    }

}