<?php

namespace ExportEngine\Contracts;

use ExportEngine\Exceptions\ExportException;

/**
 * Interface DriverInterface
 *
 * @author Aleksei Kuznetsov
 */
interface DriverInterface
{
    /**
     * @param array $head
     */
    public function setHead(array $head): void;

    /**
     * @param array $data
     */
    public function addData(array $data): void;

    /**
     * @return bool
     * @throws ExportException
     */
    public function export(): bool;

    /**
     *
     */
    public function showOnScreen(): void;
}
