<?php

namespace ExportEngine\Concrete\Configurators;

use ExportEngine\Contracts\FileConfiguratorInterface;

/**
 * Class FileConfigurator
 *
 * @author Aleksei Kuznetsov
 */
class FileConfigurator implements FileConfiguratorInterface
{
    /**
     * @var string
     */
    private $path;
    /**
     * @var string
     */
    private $name;
    /**
     * @var string
     */
    private $extension;

    /**
     * @param string $path
     */
    public function setPath(string $path): void
    {
        $this->path = $path;
    }

    /**
     * @return string
     */
    public function getPath(): string
    {
        return $this->path;
    }

    /**
     * @param string $name
     */
    public function setName(string $name): void
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getFileName(): string
    {
        return $this->getName() . '.' . $this->getExtension();
    }

    /**
     * @return string
     */
    public function getFilePath(): string
    {
        return $this->getPath() . DIRECTORY_SEPARATOR . $this->getFileName();
    }

    /**
     * @param string $extension
     */
    public function setExtension(string $extension): void
    {
        $this->extension = $extension;
    }

    /**
     * @return string
     */
    public function getExtension(): string
    {
        return $this->extension;
    }
}
