<?

namespace ExportEngine;

/**
 * Фабрика драйверов
 *
 * @author d.lanec
 */
class DriverFactory
{

	/**
	 * Создание объекта по типу
	 * @param type $type
	 * @return type
	 * @throws Exceptions\FormatNotSupported
	 */
	public static function buildByType($type)
	{
		if ( ! method_exists(self::class, "build" . $type)) {
			throw new Exceptions\FormatNotSupported($type);
		}

		return self::{"build" . $type}();
	}

	/**
	 * csv драйвер
	 * 
	 * @return \ExportEngine\Drivers\Csv
	 */
	public static function buildCsv()
	{
		return new Drivers\Csv(new \SplTempFileObject());
	}
	
	/**
	 * csv драйвер
	 * 
	 * @return \ExportEngine\Drivers\Csv
	 */
	public static function buildTxt()
	{
		return new Drivers\Txt(new \SplTempFileObject());
	}	

	/**
	 * xml драйвер
	 * @return \ExportEngine\Drivers\Xml
	 */
	public static function buildXML()
	{
		return new Drivers\Xml(new \SplTempFileObject());
	}

	/**
	 * Вар реализацияXlsx
	 * @return \ExportEngine\Drivers\Xlsx
	 */
	public static function buildXlsx()
	{
		return new Drivers\Xlsx();
	}

	/**
	 * реализация Xls
	 * @return \ExportEngine\Drivers\Xlsx
	 */
	public static function buildXls()
	{
		return new Drivers\Xls(new \SplTempFileObject());
	}

    /**
     * реализация Xls
     * @return \ExportEngine\Drivers\Xlsx
     */
    public static function buildHtml()
    {
        return new Drivers\Html(new \SplTempFileObject());
    }
}