<?

namespace ExportEngine\Drivers;

use XLSXWriter;

/**
 * экспорт Xlsx
 *
 * @author d.lanec
 */
class Xlsx implements \ExportEngine\Contracts\ExportProcessInterface
{

	protected $charSet;
	protected $data = [];
	protected $filename;
	protected $exportApi;
    protected $useXLSXWriter;
    protected $XLSXWriter;
	protected $head = [];

    public function __construct($useXLSXWriter = true)
	{
        if ($useXLSXWriter) {
            $this->XLSXWriter = new XLSXWriter();
        }
	    $this->exportApi = \Loader::getApi("export");
        $this->useXLSXWriter = $useXLSXWriter;
	}

	public function getExtendsion()
	{
		return "xlsx";
	}

    /**
     *
     * @param array $head
     * @return $this
     */
    public function getHead()
    {
        return $this->head;
    }

	/**
	 * 
	 * @param array $head
	 * @return $this
	 */
	public function setHead(array $head)
	{
		$this->head = $head;
		return $this;
	}

	/**
	 * 
	 * @return type
	 */
	public function output()
	{
		$newHead = [];

		foreach ($this->head as $k => $h) {
			$newHead [$k] = [
				"caption"	 => $h,
				"format"	 => $this->exportApi->getPhpExcelCellFormat(null)
			];
		}

		$data = [
			"name"	 => $this->filename,
			"head"	 => $newHead,
			"body"	 => $this->data
		];

		return $this->exportApi->createXLSXFile($data);
	}
	
	/**
	 * 
	 * @param type $file
	 * @return type
	 */
	public function exportToFile($file, $flag = 0)
	{
        if ($this->useXLSXWriter) {
            return $this->exportToFileUseXLSXWriter($file, $flag);
        }

		$newHead = [];

		foreach ($this->head as $k => $h) {
			$newHead [$k] = [
				"caption"	 => $h,
				"format"	 => $this->exportApi->getPhpExcelCellFormat(null)
			];
		}
		
		if(count($newHead)===0){
			foreach($this->data[0] as $k => $h){
				$newHead [$k] = [
					"caption"	 => $h,
					"format"	 => $this->exportApi->getPhpExcelCellFormat(null)
				];
			}
			unset($this->data[0]);
		}

		$data = [
			"name"	 => $this->filename,
			"head"	 => $newHead,
			"body"	 => $this->data
		];		
		
		//$data['fullPath'] = $file;
		
		$fileData =  $this->exportApi->makeXLSXFile($data);

		return copy($_SERVER['DOCUMENT_ROOT'] . $fileData['relativePath'],$file);
	}

    /**
     *
     * @param type $file
     * @return type
     */
    public function exportToFileUseXLSXWriter($file, $flag = 0)
    {

        if ($flag > 0) {

            $this->XLSXWriter->writeToFile($file);

            return true;
        }

        $priceName = 'Price';
        $head = $this->getHead();

        if (empty($head)) {

            $this->XLSXWriter->setAuthor(punycodeDecode($_SERVER['SERVER_NAME']));

            $this->setHead(array_shift($this->data));

            $headerPrice = [];
            foreach ($this->getHead() as $label => $field) {  //записываем первую строку, заголовок таблицы
                $headerPrice[$field] = 'string';
            }

            $this->XLSXWriter->writeSheetHeader($priceName, $headerPrice);
        }

        foreach ($this->data as $data) {

            $this->XLSXWriter->writeSheetRow($priceName, array_values($data));
        }

        return true;
    }

	/**
	 * set achar set
	 * @param type $charSet
	 * @return $this
	 */
	public function setCharSet($charSet)
	{
		$this->charSet = $charSet;
		return $this;
	}

	/**
	 * set data
	 * @param array $data
	 * @return $this
	 */
	public function setData(array $data)
	{
		$this->data = $data;
		return $this;
	}

	/**
	 * set filename
	 * @param type $name
	 * @return $this
	 */
	public function setFileName($name)
	{
		$this->filename = $name;
		return $this;
	}

}