<?php

namespace ExportEngine\Contracts;

/**
 * Interface FileLinesConfiguratorInterface
 *
 * @author Aleksei Kuznetsov
 */
interface FileLinesConfiguratorInterface extends FileConfiguratorInterface
{
    /**
     * @param string $charset
     */
    public function setCharset(string $charset): void;

    /**
     * @return string
     */
    public function getCharset(): string;

    /**
     * @param string $delimiter
     */
    public function setDelimiter(string $delimiter): void;

    /**
     * @return string
     */
    public function getDelimiter(): string;

    /**
     * @param string $enclosure
     */
    public function setEnclosure(string $enclosure): void;

    /**
     * @return string
     */
    public function getEnclosure(): string;

    /**
     * @param string $lineEnding
     */
    public function setLineEnding(string $lineEnding): void;

    /**
     * @return string
     */
    public function getLineEnding(): string;
}
