<?php

namespace ExportEngine;

use ExportEngine\Contracts\DriverInterface;
use ExportEngine\Contracts\ExporterInterface;
use ExportEngine\Exceptions\ExportException;

/**
 * Class OnScreenExporter
 *
 * @author Aleksei Kuznetsov
 */
class OnScreenExporter implements ExporterInterface
{
    /**
     * @var DriverInterface
     */
    protected $driver;

    /**
     * Exporter constructor.
     *
     * @param DriverInterface $driver
     */
    public function __construct(DriverInterface $driver)
    {
        $this->driver = $driver;
    }

    /**
     * @return bool
     * @throws ExportException
     */
    public function export(): bool
    {
        $this->driver->showOnScreen();

        return true;
    }
}
