<?php
namespace Core\Repository;

use Propel\Runtime\ActiveRecord\ActiveRecordInterface;

/**
 * Description of PropelQueryAbstract
 *
 * @author Dmitriy
 */
abstract class PropelQueryAbstract{

    protected $selectFilter;

    protected function getSelectFilter(){
	return $this->selectFilter;
    }

    public function setSelectFilter($selectFilter){
	$this->selectFilter = $selectFilter;
	return $this;
    }

    abstract public function buildQuery();

    abstract public function buildEntity();


    public function getQuery(){
	$query	 = $this->buildQuery();
	if($this->getSelectFilter()){
	    $query = call_user_func($this->getSelectFilter(), $query);
	}
	return $query;
    }

    /**
     * 
     * @return type
     */
    public function count(){
	return $this->buildQuery()->count();
    }

    /**
     * 
     * @param ActiveRecordInterface $entity
     * @return type
     */
    public function delete(ActiveRecordInterface $entity){
	return $entity->delete();
    }

    public function save(ActiveRecordInterface $Entity){

	try{
	    $Entity->save();

	    return true;
	    
	} catch(\Exception $ex){        
	    throw $ex;
	}
    }    
    
    public function findAll(){
	return $this->buildQuery()->find();
    }

    public function findById($id){
	return $this->buildQuery()->findPk($id);
    }

    public function findOne(){
	return $this->buildQuery()->findOne();
    }
}
