<?php

use JBZoo\Utils\Url;
use Symfony\Component\HttpFoundation\Request;

/**
 * @param string $_url
 * @param string $_title
 * @param array $params
 * @param array $url_params
 * @param bool $onlyUrl
 * @return string
 */
function anchor(string $_url, string $_title, array $params = [], array $url_params = [], bool $onlyUrl = false): string
{

    if (strpos($_url, '://') === false && strpos($_url, 'javascript') === false) {
        $url = Request::create($_url, 'GET', $url_params)->getRequestUri();
    } else {
        $url = $_url;
    }

    extract($params);
    if ($onlyUrl === true) {
        return $url;
    }

    return sprintf('<a href="%s"%s%s%s%s>%s</a>', $url,
        isset($title) ? ' title="' . $title . '"' : '',
        isset($class) ? ' class="' . $class . '"' : '',
        isset($onclick) ? ' onclick="' . $onclick . '"' : '',
        isset($target) ? ' target="' . $target . '"' : '',
        $_title
    );
}

/**
 * Форматирует ссылку в SEO формате
 * @param string $uri
 * @param string $alias
 * @param string $title
 * @param string $attributes
 * @param array $params
 * @param bool $onlyUrl
 * @return string
 */
function anchorSeo(string $uri = '', string $alias = '', string $title = '', array $attributes = [], array $params = array(), bool $onlyUrl = false)
{
    if (!empty($alias)) {
        return anchor($uri . '/' . $alias, $title, $attributes, $params, $onlyUrl);
    }

    return anchor($uri, $title, $attributes, $params, $onlyUrl);
}

/**
 * @param array $params
 * @param array $ignore
 * @return string
 */
function adaptive_url(array $params = [], array $ignore = []): string
{
    $params = array_merge(Request::createFromGlobals()->query->all(), $params);
    return Url::delArg($ignore, Url::addArg($params));
}

function admin_path(?string $path = null): string
{
    $admin = trim(ADMIN_PATH, '/');
    $path = trim($path, '/');

    if ($path) {
        return '/' . $admin . '/' . $path;
    }
    return '/' . $admin;
}

/**
 * Путь до папки кэша
 * @param string|null $path
 * @return string
 */
function cache_path(?string $path = null, bool $createDir = false): string
{
    $finalPath = BASEPATH . '/app/cache';
    $path = trim($path, '/');

    if ($path) {
        $finalPath = $finalPath . '/' . $path;
    }

    if ($createDir === true) {
        $splFile = new SplFileInfo($finalPath);
        if (!is_dir($splFile->getPath()) && !mkdir($splFile->getPath(),0777,true) && !is_dir($splFile->getPath())) {
            throw new RuntimeException('create cache dir ' . $splFile->getPath() . ' error!');
        }
    }


    return $finalPath;
}

function admin_name(): string
{
    $admin = trim(ADMIN_NAME);
    return $admin;
}

/**
 * @param string $name
 * @return string
 */
function input_get(string $name): ?string
{
    return Request::createFromGlobals()->query->get($name);
}

/**
 * @param string $name
 * @return string
 */
function input_get_int(string $name): ?int
{
    $value = Request::createFromGlobals()->query->get($name);
    return $value ? (int)$value : null;
}

/**
 * @param string $name
 * @return string
 */
function input_post(string $name): ?string
{
    return Request::createFromGlobals()->request->get($name);
}

/**
 * @return string
 */
function current_url(): string
{
    return str_replace(Url::root(), '', Url::current());
}

/**
 * @return string
 */
function site_url(): string
{
    return Url::root();
}

/**
 * @param int $n
 * @return string
 */
function nbs($n = 1): string
{
    return str_repeat('&nbsp;', $n);
}
