<?php

namespace Core\Form\Control;

use ActiveTable\Contracts\FormControlRenderInterface;

/**
 * Description of FormControl
 *
 * @author Dmitriy
 */
abstract class FormControl extends BaseControl implements FormControlRenderInterface
{

    protected $width;
    protected string $name = self::class;
    protected $class;
    protected $id;
    protected $value;
    protected $style;
    protected $custom_value_fn = false;
    protected $data = [];

    public function setWidth(int $width)
    {
        $this->width = $width;
        return $this;
    }


    function addData(string $name, $value)
    {
        $this->data [$name] = $value;
        return $this;
    }

    function getValue()
    {
        return $this->value;
    }

    function setValue($value)
    {
        $this->value = $value;
        return $this;
    }

    function getName(): string
    {
        return $this->name;
    }

    function setName(string $name)
    {
        $this->name = $name;
        return $this;
    }

    function getClass(): ?string
    {
        return $this->class;
    }

    function setClass(string $class)
    {
        $this->class = $class;
        return $this;
    }

    public function addClass(string $class)
    {
        $this->class .= ' ' . $class;
        return $this;
    }
    
    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    public function getStyle()
    {
        return $this->style;
    }

    public function setStyle(string $style)
    {
        $this->style = $style;
        return $this;
    }

    public function getFn()
    {
        return $this->custom_value_fn;
    }

    public function setFn($fn, $method = false)
    {
        $this->custom_value_fn = !$method ? $fn : [$fn, $method];
        return $this;
    }


    abstract function render(): string;
}