<?php declare(strict_types=1);

namespace Core\Console;

use Diamond\Factory\Logger;
use Monolog\Handler\StreamHandler;
use Psr\Log\LoggerAwareInterface;
use Psr\Log\LoggerAwareTrait;
use Psr\Log\NullLogger;
use Symfony\Component\Console\Application as CoreApp;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * 
 */
class Application extends CoreApp
{

    public function __construct(string $name = 'UNKNOWN', string $version = 'UNKNOWN')
    {
        parent::__construct($name, $version);
        $logger = (new \Monolog\Logger('console_logger'));
        $stream = new StreamHandler(sprintf(
            BASEPATH . '/app/logs/' . 'errors_console' . '_%s.log', date( "d_m_y")
        ), 'error');
        $stream->setFormatter(new \Monolog\Formatter\LineFormatter("[%datetime%] [%level_name%] %message% [Context %context% Extra %extra%]\n", 'd/m/Y H:i:s'));

        $logger->pushHandler($stream);
        $this->logger = $logger;
        $this->setCatchExceptions(false);
    }


    /**
     * Gets the default commands that should always be available.
     *
     * @return array An array of default Command instances
     */
    protected function getDefaultCommands()
    {
        // Keep the core default commands to have the HelpCommand
        // which is used when using the --help option
        $defaultCommands = parent::getDefaultCommands();
        $defaultCommands [] = new Commands\PrepareDirsCommand();
        $defaultCommands [] = new Commands\InfoCommand();
        $defaultCommands [] = new Commands\InstallPackagesCommand;
        $defaultCommands [] = new Commands\InstallCommand;
        $defaultCommands [] = new Commands\SeedBuildCommand;
        $defaultCommands [] = new Commands\SeedResetCommand;
        $defaultCommands [] = new Commands\MigrationMigrateCommand();
        $defaultCommands [] = new Commands\MigrationDiffCommand();
        $defaultCommands [] = new Commands\SqlBuildCommand();
        $defaultCommands [] = new Commands\SqlInsertCommand();

        $defaultCommands [] = new Commands\BuildModuleCommand();
        $defaultCommands [] = new Commands\BuildModelCommand();
        $defaultCommands [] = new Commands\BuildEntityCommand();

        $defaultCommands [] = new Commands\StatusCommand();
        $defaultCommands [] = new Commands\SessionCommand();
        $defaultCommands [] = new Commands\Cache();

        return $defaultCommands;
    }

    public function run(InputInterface $input = null, OutputInterface $output = null)
    {
        try{
            return parent::run($input, $output);
        }
        catch (\Throwable $exception){

            $item = [
                'file' => $exception->getFile(),
                'line' => $exception->getLine(),
                'trace' => $exception->getTraceAsString()
            ];
            $this->logger->error(get_class($exception).': '. $exception->getMessage(),$item);
            throw $exception;
        }
    }

}
