<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 31.08.2020
 * Time: 23:23
 */

namespace Core\Helpers;


class Text
{

    public static function ucfirst(string $string, string $encoding = 'UTF-8'): string
    {

        return mb_convert_case(trim($string), MB_CASE_TITLE, $encoding);
    }

    /**
     * @param int $length
     * @param string $chars
     * @return string
     */
    public static function generatePassword($length = 6, $chars = 'qazxswedcvfrtgbnhyujmkiolp1234567890QAZXSWEDCVFRTGBNHYUJMKIOLP'): string
    {
        //здесь генерируем случайную комбинацию цифр
        $numChars = strlen($chars);
        $string = '';
        for ($i = 0; $i < $length; $i++) {
            $string .= substr($chars, rand(1, $numChars) - 1, 1);
        }
        return $string;
    }

    /**
     * @param $inn
     * @param bool $stripkop
     * @return string|string[]|null
     */
    public static function num2str(string $inn, $stripkop = false)
    {

        $nol = 'ноль';
        $str[100] = array('', 'сто', 'двести', 'триста', 'четыреста', 'пятьсот', 'шестьсот', 'семьсот', 'восемьсот', 'девятьсот');
        $str[11] = array('', 'десять', 'одиннадцать', 'двенадцать', 'тринадцать', 'четырнадцать', 'пятнадцать', 'шестнадцать', 'семнадцать', 'восемнадцать', 'девятнадцать', 'двадцать');
        $str[10] = array('', 'десять', 'двадцать', 'тридцать', 'сорок', 'пятьдесят', 'шестьдесят', 'семьдесят', 'восемьдесят', 'девяносто');
        $sex = array(
            array('', 'один', 'два', 'три', 'четыре', 'пять', 'шесть', 'семь', 'восемь', 'девять'),// m
            array('', 'одна', 'две', 'три', 'четыре', 'пять', 'шесть', 'семь', 'восемь', 'девять') // f
        );
        $forms = array(
            array('копейка', 'копейки', 'копеек', 1), // 10^-2
            array('рубль', 'рубля', 'рублей',  0), // 10^ 0
            //array('гривна', 'гривны', 'гривен', 0), // 10^ 0
            array('тысяча', 'тысячи', 'тысяч', 1), // 10^ 3
            array('миллион', 'миллиона', 'миллионов', 0), // 10^ 6
            array('миллиард', 'миллиарда', 'миллиардов', 0), // 10^ 9
            array('триллион', 'триллиона', 'триллионов', 0), // 10^12
        );
        $out = $tmp = array();
        // Поехали!
        $tmp = explode('.', str_replace(',', '.', $inn));
        $rub = number_format($tmp[0], 0, '', '-');
        if ($rub == 0) $out[] = $nol;
        // нормализация копеек
        $kop = isset($tmp[1]) ? substr(str_pad($tmp[1], 2, '0', STR_PAD_RIGHT), 0, 2) : '00';
        $segments = explode('-', $rub);
        $offset = sizeof($segments);
        if ((int)$rub == 0) { // если 0 рублей
            $o[] = $nol;
            $o[] = self::morph(0, $forms[1][0], $forms[1][1], $forms[1][2]);
        } else {
            foreach ($segments as $k => $lev) {
                $sexi = (int)$forms[$offset][3]; // определяем род
                $ri = (int)$lev; // текущий сегмент
                if ($ri == 0 && $offset > 1) {// если сегмент==0 & не последний уровень(там Units)
                    $offset--;
                    continue;
                }
                // нормализация
                $ri = str_pad($ri, 3, '0', STR_PAD_LEFT);
                // получаем циферки для анализа
                $r1 = (int)substr($ri, 0, 1); //первая цифра
                $r2 = (int)substr($ri, 1, 1); //вторая
                $r3 = (int)substr($ri, 2, 1); //третья
                $r22 = (int)$r2 . $r3; //вторая и третья
                // разгребаем порядки
                if ($ri > 99) $o[] = $str[100][$r1]; // Сотни
                if ($r22 > 20) {// >20
                    $o[] = $str[10][$r2];
                    $o[] = $sex[$sexi][$r3];
                } else { // <=20
                    if ($r22 > 9) $o[] = $str[11][$r22 - 9]; // 10-20
                    elseif ($r22 > 0) $o[] = $sex[$sexi][$r3]; // 1-9
                }
                // Рубли
                $o[] = self::morph($ri, $forms[$offset][0], $forms[$offset][1], $forms[$offset][2]);
                $offset--;
            }
        }
        // Копейки
        if (!$stripkop) {
            $o[] = $kop;
            $o[] = self::morph($kop, $forms[0][0], $forms[0][1], $forms[0][2]);
        }
        return preg_replace("/\s{2,}/", ' ', implode(' ', $o));
    }

    /**
     * Склоняем словоформу
     * @ author runcore
     */
    public static function morph(int $n, string $f1, string $f2, string $f5)
    {
        $n = abs($n) % 100;
        $n1 = $n % 10;
        if ($n > 10 && $n < 20) return $f5;
        if ($n1 > 1 && $n1 < 5) return $f2;
        if ($n1 == 1) return $f1;
        return $f5;
    }

    /**
     * @param string $str
     * @return mixed
     */
    public static function highlightCode(string $str)
    {
        /* The highlight string function encodes and highlights
         * brackets so we need them to start raw.
         *
         * Also replace any existing PHP tags to temporary markers
         * so they don't accidentally break the string out of PHP,
         * and thus, thwart the highlighting.
         */
        $str = str_replace(
            array('&lt;', '&gt;', '<?', '?>', '<%', '%>', '\\', '</script>'),
            array('<', '>', 'phptagopen', 'phptagclose', 'asptagopen', 'asptagclose', 'backslashtmp', 'scriptclose'),
            $str
        );

        // The highlight_string function requires that the text be surrounded
        // by PHP tags, which we will remove later
        $str = highlight_string('<?php ' . $str . ' ?>', TRUE);

        // Remove our artificially added PHP, and the syntax highlighting that came with it
        $str = preg_replace(
            array(
                '/<span style="color: #([A-Z0-9]+)">&lt;\?php(&nbsp;| )/i',
                '/(<span style="color: #[A-Z0-9]+">.*?)\?&gt;<\/span>\n<\/span>\n<\/code>/is',
                '/<span style="color: #[A-Z0-9]+"\><\/span>/i'
            ),
            array(
                '<span style="color: #$1">',
                "$1</span>\n</span>\n</code>",
                ''
            ), $str
        );

        // Replace our markers back to PHP tags.
        return str_replace(
            array('phptagopen', 'phptagclose', 'asptagopen', 'asptagclose', 'backslashtmp', 'scriptclose'),
            array('&lt;?', '?&gt;', '&lt;%', '%&gt;', '\\', '&lt;/script&gt;'), $str
        );
    }

    /**
     * @param string $str
     * @return mixed
     * @deprecated
     * @see Text::highlightCode()
     */
    public static function highlight_code(string $str)
    {
        return self::highlightCode($str);
    }

    /**
     * @param string $str
     * @param int $n
     * @param string $end_char
     * @return string
     * @deprecated
     * @see Text::characterLimiter()
     */
    public static function character_limiter(string $str, $n = 500, $end_char = '&#8230;'): string
    {
        return self::characterLimiter($str, $n, $end_char);
    }

    /**
     * Выводит строку с лимитом
     * @param string $str
     * @param int $n
     * @param string $end_char
     * @return string
     */
    public static function characterLimiter(string $str, $n = 500, $end_char = '&#8230;'): string
    {
        if (mb_strlen($str) < $n) {
            return $str;
        }

        // a bit complicated, but faster than preg_replace with \s+
        $str = preg_replace('/ {2,}/', ' ', str_replace(array("\r", "\n", "\t", "\x0B", "\x0C"), ' ', $str));

        if (mb_strlen($str) <= $n) {
            return $str;
        }

        $out = '';
        foreach (explode(' ', trim($str)) as $val) {
            $out .= $val . ' ';

            if (mb_strlen($out) >= $n) {
                $out = trim($out);
                return (mb_strlen($out) === mb_strlen($str)) ? $out : $out . $end_char;
            }
        }

        return $out;
    }

    /**
     * Очистка текста от html с обрезанием
     * @param string $text
     * @param int $l
     * @return string
     */
    public static function clearText(string $text, int $l = 100): string
    {
        return trim(str_replace(array("\r\n", "\n"), '', mb_strcut(strip_tags($text), 0, $l)));
    }

    /**
     * Находит изображение в тексте и выставляет определенную высоту
     * @param $text
     * @param int $h
     * @return string
     */
    public static function createImgFromText(string $text, int $h = null): string
    {
        return self::createImgFromTextReal($text,
            ($h > 0 ? "style=\"max-height:{$h}px !important; width:100%  !important;\"" : '')
        );

    }

    /**
     * поиск
     * @param string $text
     * @return array
     */
    public static function createImgPathsFromText(string $text): array
    {
        if (preg_match_all("~<img.*?src=[\"](.*?)[\"]~", $text, $match)) {
            return $match[1];
        }

        return [];
    }

    /**
     * Находит изображение в тексте как есть
     * @param string $text
     * @param string $attr
     * @return string
     */
    public static function createImgFromTextReal(string $text, string $attr = ''): ?string
    {
        if (preg_match("~<img.*?src=[\"](.*?)[\"]~", $text, $match)) {

            return sprintf('<img %s src="%s" />', $attr, $match[1]);
        }

        return '';
    }

    /**
     * Транслитерация
     * @param string $string
     * @return string
     */
    public static function rus2translit(string $text): string
    {

        $converter = array(
            'а' => 'a', 'б' => 'b', 'в' => 'v',
            'г' => 'g', 'д' => 'd', 'е' => 'e',
            'ё' => 'e', 'ж' => 'zh', 'з' => 'z',
            'и' => 'i', 'й' => 'y', 'к' => 'k',
            'л' => 'l', 'м' => 'm', 'н' => 'n',
            'о' => 'o', 'п' => 'p', 'р' => 'r',
            'с' => 's', 'т' => 't', 'у' => 'u',
            'ф' => 'f', 'х' => 'h', 'ц' => 'c',
            'ч' => 'ch', 'ш' => 'sh', 'щ' => 'sch',
            'ь' => '', 'ы' => 'y', 'ъ' => '',
            'э' => 'e', 'ю' => 'yu', 'я' => 'ya',
            'А' => 'A', 'Б' => 'B', 'В' => 'V',
            'Г' => 'G', 'Д' => 'D', 'Е' => 'E',
            'Ё' => 'E', 'Ж' => 'Zh', 'З' => 'Z',
            'И' => 'I', 'Й' => 'Y', 'К' => 'K',
            'Л' => 'L', 'М' => 'M', 'Н' => 'N',
            'О' => 'O', 'П' => 'P', 'Р' => 'R',
            'С' => 'S', 'Т' => 'T', 'У' => 'U',
            'Ф' => 'F', 'Х' => 'H', 'Ц' => 'C',
            'Ч' => 'Ch', 'Ш' => 'Sh', 'Щ' => 'Sch',
            'Ь' => '', 'Ы' => 'Y', 'Ъ' => '',
            'Э' => 'E', 'Ю' => 'Yu', 'Я' => 'Ya'
        );
        return str_replace( array_keys($converter), $converter, $text);
    }

    public static function rus2translit2(string $text): string
    {
        $text = iconv('UTF-8', 'ASCII//TRANSLIT//IGNORE', $text);

        // Очистка для URL
        $text = strtolower($text);
        $text = preg_replace('/[^a-z0-9\-]/', '-', $text);
        $text = preg_replace('/-+/', '-', $text);
        $text = trim($text, '-');

        return $text;
    }

    /**
     * Производит замену имени на транслит + замена пробелов на -
     * используется для СЕО
     * @param string $string
     * @return string
     */
    public static function replaceAndTranslite(string $string): string
    {
        return strtolower(preg_replace("~\-{2,}~", '-', str_replace([' ', '/'], '-',
            self::rus2translit($string))));
    }

    /**
     * @deprecated
     * ЧПУ улучшеная веосия с обрезкой левых симовлов
     * @param string $str
     * @return string
     */
    public static function str2url(string $str): string
    {
        // переводим в транслит
        $str = self::rus2translit($str);

        //echo $str;
        // в нижний регистр
        $str = strtolower($str);
        // заменям все ненужное нам на "-"
        $str = preg_replace("~\-{2,}~", "-", preg_replace('~[^-a-z0-9_]+~u', '-', $str));

        // удаляем начальные и конечные '-'
        $str = trim($str, "-");

        return $str;
    }

    /**
     * Улучшенная версия
     * @param string $str
     * @return string
     */
    public static function str2url2(string $str): string
    {
        // переводим в транслит
        $str = self::rus2translit2($str);

        //echo $str;
        // в нижний регистр
        $str = strtolower($str);
        // заменям все ненужное нам на "-"
        $str = preg_replace("~\-{2,}~", "-", preg_replace('~[^-a-z0-9_]+~u', '-', $str));

        // удаляем начальные и конечные '-'
        $str = trim($str, "-");

        return $str;
    }

    /**
     * Преобразует текст начинющийся с заглавной
     * используется для названий товаров
     * @param string $text
     * @return string
     */
    public static function caseText(string $text): string
    {
        return mb_convert_case(
                mb_substr($text, 0, 1, 'UTF-8'), MB_CASE_TITLE, "UTF-8"
            ) .
            mb_substr($text, 1, 9999, 'UTF-8');
    }

    /**
     * Приобразует адреса перечисленные через запятую в ссылки
     * @param string $emails
     * @param string $delimeter
     * @param string $delimeterOutput
     * @return string
     */
    public static function emailsToAnchors(string $emails, string $delimeter = ';', string $delimeterOutput = ' '): string
    {
        if (!preg_match_all('~(.*?)(' . $delimeter . '|$)~', $emails, $match)) {
            return anchor(sprintf('mailto:%s', $emails), $emails);
        }

        $emailsAr = [];

        foreach ($match[1] as $email) {
            if (empty($email))
                continue;
            $emailsAr[$email] = sprintf("<a href=\"mailto:%s\">%s</a>", $email, $email);
        }

        $list = implode($delimeterOutput, $emailsAr);

        return $list;
    }

    /**
     * формирует спимсок из массиво с открывалкой/закрывалкой
     * @param array $priceList
     * @return string
     */
    public static function toggleList(array $priceList, string $label = 'прайс-листов'): string
    {
        $quantity = count($priceList);

        $rows = [];
        foreach ($priceList as $key => $price) {
            $isAddClass = $quantity > 3 && $key > 1;
            $rows[] = '<div class="big-list' . ($isAddClass ? ' list-hide' : '') . '">' . $price . '</div>';
        }

        if (count($priceList) > 3) {
            $rows[] = '<div class="big-list-toggle" data-event="big-list"></div>';
        }

        if (count($rows) > 3) {
            $title = 'Показать / скрыть весь список ' . $label;
        } else {
            $title = '';
        }


        return '<div class="big-list closed" title="' . $title . '">' . implode('', $rows) . '</div>';
    }
}