<?php

namespace Core\Form\Control;

class MenuItemAction implements ControlRenderInterface
{

    private $action;
    private $label;
    private $icon;
    private $confirm;
    private $id;

    public function __construct(int $id, string $action, string $label, string $confirm = '', string $icon = '')
    {
        $this->action = $action;
        $this->label = $label;
        $this->icon = $icon;
        $this->confirm = $confirm;
        $this->id = $id;
    }

    public function render(): string
    {
        return
            anchor('javascript:void(0);',($this->icon ?  '<i class="'.$this->icon.'"></i> ':'' ). $this->label , [
                'onclick' => "action_row({$this->id},'".$this->action."','".$this->confirm."')"
            ]);
    }

}