<?php declare(strict_types=1);

namespace Core\Helpers;

use Symfony\Component\HttpFoundation\Request;

class InputHelper
{

    public static function getInteger(string $name, ?int $default = null): ?int
    {
        $value = Request::createFromGlobals()->query->get($name);

        if (is_string($value)) {
            return (int)$value;
        }

        return $default;
    }

    public static function getString(string $name, ?string $default = null): ?string
    {
        $value = Request::createFromGlobals()->query->get($name);

        if (is_string($value)) {
            return $value;
        }

        return $default;
    }

    public static function getArray(string $name, ?array $default = null): ?array
    {
        $value = Request::createFromGlobals()->query->get($name);

        if (is_array($value)) {
            return $value;
        }

        return $default;
    }
}